<?php

class Ambient_Routee_Model_Observer {

    public function Customeraddrouteecron(Varien_Event_Observer $observer) {
        $frontName = Mage::app()->getRequest()->getRouteName();
        $controllerName = Mage::app()->getRequest()->getControllerName();
        $actionName = Mage::app()->getRequest()->getActionName();
        $myURI = $frontName . '_' . $controllerName . '_' . $actionName;
        $postt = Mage::app()->getRequest()->getPost();

        if ($myURI == "customer_account_createpost") {
            Mage::log("start add customer event", null, "myroutee.log");
            $uuid = Mage::getStoreConfig('routeesection/routeegroup/routee_mmid');
            $customer = $observer->getEvent()->getCustomer();

            //customer add
            $event = "CustomerAdd";

            $reqdata = array();
            $customerreq = array();
            $addressreq = array();

            $customerreq['id'] = $customer->getId();
            $customerreq['firstname'] = $customer->getFirstname();
            $customerreq['lastname'] = $customer->getLastname();
            $customerreq['email'] = $customer->getEmail();

            if ($customer->getMiddlename()) {
                $customerreq['middlename'] = $customer->getMiddlename();
            }

            if ($customer->getDob()) {
                $customerreq['birthday'] = date('d/m/Y', strtotime($customer->getDob()));
            }

            if ($customer->getTaxvat()) {
                $customerreq['taxvat'] = $customer->getTaxvat();
            }

            if ($customer->getGender()) {
                if ($customer->getGender() == 1) {
                    $customerreq['gender'] = "Male";
                } else if ($customer->getGender() == 2) {
                    $customerreq['gender'] = "Female";
                }
            }

            if ($postt['is_subscribed']) {
                $customerreq['newsletter'] = true;
            } else {
                $customerreq['newsletter'] = false;
            }

            $reqdata['customer'] = $customerreq;
            $reqdata['addresses'] = $addressreq;

            $eventdata = array();
            $eventdata['data'] = $reqdata;
            $eventdata['uuid'] = $uuid;
            $eventdata['event'] = $event;

            $customerdata = Mage::helper('core')->jsonEncode($eventdata);

            $url = "https://idata.routee.net/api/event";

            $c = curl_init();
            curl_setopt($c, CURLOPT_URL, $url);
            curl_setopt($c, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
            curl_setopt($c, CURLOPT_POST, true);
            curl_setopt($c, CURLOPT_POSTFIELDS, $customerdata);
            curl_setopt($c, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($c, CURLOPT_TIMEOUT, 30);
            $response = curl_exec($c);
            curl_close($c);

            Mage::log("end add customer event", null, "myroutee.log");
        }
    }

    public function Customerupdaterouteecron(Varien_Event_Observer $observer) {
        $frontName = Mage::app()->getRequest()->getRouteName();
        $controllerName = Mage::app()->getRequest()->getControllerName();
        $actionName = Mage::app()->getRequest()->getActionName();
        $myURI = $frontName . '_' . $controllerName . '_' . $actionName;

        if ($myURI != "customer_account_createpost") {
            Mage::log("start update customer event", null, "myroutee.log");

            $uuid = Mage::getStoreConfig('routeesection/routeegroup/routee_mmid');

            $customer = $observer->getEvent()->getCustomer();
            $subscriber = Mage::getModel('newsletter/subscriber')->loadByEmail($customer->getEmail());

            //customer add
            $event = "CustomerUpdate";

            $reqdata = array();
            $customerreq = array();
            $addressreq = array();

            $customerreq['id'] = $customer->getId();
            $customerreq['firstname'] = $customer->getFirstname();
            $customerreq['lastname'] = $customer->getLastname();
            $customerreq['email'] = $customer->getEmail();

            if ($customer->getMiddlename()) {
                $customerreq['middlename'] = $customer->getMiddlename();
            }

            if ($customer->getDob()) {
                $customerreq['birthday'] = date('d/m/Y', strtotime($customer->getDob()));
            }

            if ($customer->getTaxvat()) {
                $customerreq['taxvat'] = $customer->getTaxvat();
            }

            if ($customer->getGender()) {
                if ($customer->getGender() == 1) {
                    $customerreq['gender'] = "Male";
                } else if ($customer->getGender() == 2) {
                    $customerreq['gender'] = "Female";
                }
            }

            if ($subscriber->getSubscriberStatus()) {
                $customerreq['newsletter'] = true;
            } else {
                $customerreq['newsletter'] = false;
            }

            $reqdata['customer'] = $customerreq;

            $customer1 = Mage::getModel('customer/customer')->load($customer->getId());
            $addressreq_new = array();
            foreach ($customer1->getAddresses() as $address) {
                $country = Mage::app()->getLocale()->getCountryTranslation($address->getCountryId());
                $street = $address->getStreet();
                $addressreq = array();
                $addressreq['country'] = $country;
                $addressreq['city'] = $address->getCity();
                $addressreq['address1'] = $street[0];
                $addressreq['address2'] = $street[1];
                $addressreq['postcode'] = $address->getPostcode();

                if ($address->getCompany()) {
                    $addressreq['company'] = $address->getCompany();
                }

                if ($address->getRegion()) {
                    $addressreq['region'] = $address->getRegion();
                }

                if ($address->getTelephone()) {
                    $addressreq['phone'] = $address->getTelephone();
                }

                if ($address->getFax()) {
                    $addressreq['fax'] = $address->getFax();
                }
                $addressreq_new[] = $addressreq;
            }

            $reqdata['addresses'] = $addressreq_new;

            $eventdata = array();
            $eventdata['data'] = $reqdata;
            $eventdata['uuid'] = $uuid;
            $eventdata['event'] = $event;

            $customerdata = Mage::helper('core')->jsonEncode($eventdata);
            $url = "https://idata.routee.net/api/event";

            $c = curl_init();
            curl_setopt($c, CURLOPT_URL, $url);
            curl_setopt($c, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
            curl_setopt($c, CURLOPT_POST, true);
            curl_setopt($c, CURLOPT_POSTFIELDS, $customerdata);
            curl_setopt($c, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($c, CURLOPT_TIMEOUT, 30);
            $response = curl_exec($c);
            curl_close($c);

            Mage::log("end update customer event", null, "myroutee.log");
        }
    }

    public function addressSaverouteecron(Varien_Event_Observer $observer) {
        $customeradd = $observer->getEvent()->getCustomerAddress();
        if (!$customeradd->getIsCustomerSaveTransaction()) {
            Mage::log("start update customer event with address", null, "myroutee.log");
            $uuid = Mage::getStoreConfig('routeesection/routeegroup/routee_mmid');
            $customer = Mage::getModel('customer/customer')->load($customeradd->getCustomerId());
            $subscriber = Mage::getModel('newsletter/subscriber')->loadByEmail($customer->getEmail());

            //customer add
            $event = "CustomerUpdate";

            $reqdata = array();
            $customerreq = array();
            $addressreq = array();

            $customerreq['id'] = $customer->getId();
            $customerreq['firstname'] = $customer->getFirstname();
            $customerreq['lastname'] = $customer->getLastname();
            $customerreq['email'] = $customer->getEmail();

            if ($customer->getMiddlename()) {
                $customerreq['middlename'] = $customer->getMiddlename();
            }

            if ($customer->getDob()) {
                $customerreq['birthday'] = date('d/m/Y', strtotime($customer->getDob()));
            }

            if ($customer->getTaxvat()) {
                $customerreq['taxvat'] = $customer->getTaxvat();
            }

            if ($customer->getGender()) {
                if ($customer->getGender() == 1) {
                    $customerreq['gender'] = "Male";
                } else if ($customer->getGender() == 2) {
                    $customerreq['gender'] = "Female";
                }
            }

            if ($subscriber->getSubscriberStatus()) {
                $customerreq['newsletter'] = true;
            } else {
                $customerreq['newsletter'] = false;
            }

            $reqdata['customer'] = $customerreq;

            $addressreq_new = array();
            foreach ($customer->getAddresses() as $address) {
                $addressreq = array();
                $country = Mage::app()->getLocale()->getCountryTranslation($address->getCountryId());
                $street = $address->getStreet();
                $addressreq['country'] = $country;
                $addressreq['city'] = $address->getCity();
                $addressreq['address1'] = $street[0];
                $addressreq['address2'] = $street[1];
                $addressreq['postcode'] = $address->getPostcode();

                if ($address->getCompany()) {
                    $addressreq['company'] = $address->getCompany();
                }

                if ($address->getRegion()) {
                    $addressreq['region'] = $address->getRegion();
                }

                if ($address->getTelephone()) {
                    $addressreq['phone'] = $address->getTelephone();
                }

                if ($address->getFax()) {
                    $addressreq['fax'] = $address->getFax();
                }
                $addressreq_new[] = $addressreq;
            }

            $reqdata['addresses'] = $addressreq_new;

            $eventdata = array();
            $eventdata['data'] = $reqdata;
            $eventdata['uuid'] = $uuid;
            $eventdata['event'] = $event;

            $customerdata = Mage::helper('core')->jsonEncode($eventdata);
            $url = "https://idata.routee.net/api/event";

            $c = curl_init();
            curl_setopt($c, CURLOPT_URL, $url);
            curl_setopt($c, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
            curl_setopt($c, CURLOPT_POST, true);
            curl_setopt($c, CURLOPT_POSTFIELDS, $customerdata);
            curl_setopt($c, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($c, CURLOPT_TIMEOUT, 30);
            $response = curl_exec($c);
            curl_close($c);

            Mage::log("end update customer event with address", null, "myroutee.log");
        }
    }

    public function productaddupdaterouteecron(Varien_Event_Observer $observer) {
        $productid = Mage::app()->getRequest()->getParam('id');

        if ($productid) {
            Mage::log("start update product event", null, "myroutee.log");
            $uuid = Mage::getStoreConfig('routeesection/routeegroup/routee_mmid');
            $product = $observer->getEvent()->getProduct();

            $event = "ProductUpdate";

            $reqdata = array();
            $reqdata['product_id'] = $product->getId();

            if ($product->getTypeId() == "simple") {
                $parentIds = Mage::getModel('catalog/product_type_grouped')->getParentIdsByChild($product->getId());
                if (!$parentIds)
                    $parentIds = Mage::getModel('catalog/product_type_configurable')->getParentIdsByChild($product->getId());
                if (isset($parentIds[0])) {
                    $reqdata['parent_id'] = $parentIds[0];
                }
            }

            $reqdata['name'] = $product->getName();
            $reqdata['description'] = $product->getDescription();
            $reqdata['short_description'] = $product->getShortDescription();

            $categoryIds = $product->getCategoryIds();
            $catname = array();
            if (count($categoryIds)) {
                foreach ($categoryIds as $id) {
                    $cat = Mage::getModel('catalog/category')->load($id);
                    $catname[] = $cat->getName();
                }
            }
            $reqdata['categories'] = $catname;

            $stock = Mage::getModel('cataloginventory/stock_item')->loadByProduct($product);
            $reqdata['stock_quantity'] = (int) $stock->getQty();

            $reqdata['price'] = $product->getPrice();
            $reqdata['discount'] = array(
                'price' => $product->getSpecialPrice(),
                'date_start' => date('d/m/Y', strtotime($product->getSpecialFromDate())),
                'date_end' => date('d/m/Y', strtotime($product->getSpecialToDate())),
                'quantity' => (int) $stock->getQty()
            );

            if ($product->getImage()) {
                $reqdata['image_link'] = Mage::getBaseUrl(Mage_Core_Model_Store::URL_TYPE_MEDIA) . 'catalog/product' . $product->getImage();
            } else {
                $reqdata['image_link'] = '';
            }

            $reqdata['product_link'] = $product->getProductUrl(true);
            $reqdata['sku'] = $product->getSku();

            $eventdata = array();
            $eventdata['data'] = $reqdata;
            $eventdata['uuid'] = $uuid;
            $eventdata['event'] = $event;

            $productdata = Mage::helper('core')->jsonEncode($eventdata);

            $url = "https://idata.routee.net/api/event";

            $c = curl_init();
            curl_setopt($c, CURLOPT_URL, $url);
            curl_setopt($c, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
            curl_setopt($c, CURLOPT_POST, true);
            curl_setopt($c, CURLOPT_POSTFIELDS, $productdata);
            curl_setopt($c, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($c, CURLOPT_TIMEOUT, 30);
            $response = curl_exec($c);
            curl_close($c);

            Mage::log("end update product event", null, "myroutee.log");
        } else {
            Mage::log("start add product event", null, "myroutee.log");
            $uuid = Mage::getStoreConfig('routeesection/routeegroup/routee_mmid');
            $product = $observer->getEvent()->getProduct();

            $event = "ProductAdd";

            $reqdata = array();
            $reqdata['product_id'] = $product->getId();
            $reqdata['name'] = $product->getName();
            $reqdata['description'] = $product->getDescription();
            $reqdata['short_description'] = $product->getShortDescription();

            $categoryIds = $product->getCategoryIds();
            $catname = array();
            if (count($categoryIds)) {
                foreach ($categoryIds as $id) {
                    $cat = Mage::getModel('catalog/category')->load($id);
                    $catname[] = $cat->getName();
                }
            }
            $reqdata['categories'] = $catname;

            $stock = Mage::getModel('cataloginventory/stock_item')->loadByProduct($product);
            $reqdata['stock_quantity'] = (int) $stock->getQty();

            $reqdata['price'] = $product->getPrice();
            $reqdata['discount'] = array(
                'price' => $product->getSpecialPrice(),
                'date_start' => date('d/m/Y', strtotime($product->getSpecialFromDate())),
                'date_end' => date('d/m/Y', strtotime($product->getSpecialToDate())),
                'quantity' => (int) $stock->getQty()
            );

            if ($product->getImage()) {
                $reqdata['image_link'] = Mage::getBaseUrl(Mage_Core_Model_Store::URL_TYPE_MEDIA) . 'catalog/product' . $product->getImage();
            } else {
                $reqdata['image_link'] = '';
            }
            $reqdata['product_link'] = $product->getProductUrl(true);

            $eventdata = array();
            $eventdata['data'] = $reqdata;
            $eventdata['uuid'] = $uuid;
            $eventdata['event'] = $event;

            $productdata = Mage::helper('core')->jsonEncode($eventdata);

            $url = "https://idata.routee.net/api/event";

            $c = curl_init();
            curl_setopt($c, CURLOPT_URL, $url);
            curl_setopt($c, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
            curl_setopt($c, CURLOPT_POST, true);
            curl_setopt($c, CURLOPT_POSTFIELDS, $productdata);
            curl_setopt($c, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($c, CURLOPT_TIMEOUT, 30);
            $response = curl_exec($c);
            curl_close($c);

            Mage::log("end add product event", null, "myroutee.log");
        }
    }

    public function inventorychangerouteecron(Varien_Event_Observer $observer) {
        $event = $observer->getEvent();
        $_item = $event->getItem();

        if ((int) $_item->getData('qty') != (int) $_item->getOrigData('qty')) {
            Mage::log("start inventory change event", null, "myroutee.log");

            $uuid = Mage::getStoreConfig('routeesection/routeegroup/routee_mmid');

            $event = "ProductStockUpdate";

            $reqdata = array();
            $reqdata['product_id'] = $_item->getProductId();
            $reqdata['stock_quantity'] = (int) $_item->getQty();

            $eventdata = array();
            $eventdata['data'] = $reqdata;
            $eventdata['uuid'] = $uuid;
            $eventdata['event'] = $event;

            $stockdata = Mage::helper('core')->jsonEncode($eventdata);

            $url = "https://idata.routee.net/api/event";

            $c = curl_init();
            curl_setopt($c, CURLOPT_URL, $url);
            curl_setopt($c, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
            curl_setopt($c, CURLOPT_POST, true);
            curl_setopt($c, CURLOPT_POSTFIELDS, $stockdata);
            curl_setopt($c, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($c, CURLOPT_TIMEOUT, 30);
            $response = curl_exec($c);
            curl_close($c);

            Mage::log("end inventory change event", null, "myroutee.log");
        }

        if (((int) $_item->getData('is_in_stock') != (int) $_item->getOrigData('is_in_stock') && $_item->getData('is_in_stock') == 0) || ((int) $_item->getData('qty') <= 0 && (int) $_item->getData('qty') != (int) $_item->getOrigData('qty'))) {
            Mage::log("start out of stock notify event", null, "myroutee.log");

            $uuid = Mage::getStoreConfig('routeesection/routeegroup/routee_mmid');

            $event = "ProductOutOfStock";

            $reqdata = array();
            $reqdata['product_id'] = $_item->getProductId();

            $eventdata = array();
            $eventdata['data'] = $reqdata;
            $eventdata['uuid'] = $uuid;
            $eventdata['event'] = $event;

            $outstockdata = Mage::helper('core')->jsonEncode($eventdata);

            $url = "https://idata.routee.net/api/event";

            $c = curl_init();
            curl_setopt($c, CURLOPT_URL, $url);
            curl_setopt($c, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
            curl_setopt($c, CURLOPT_POST, true);
            curl_setopt($c, CURLOPT_POSTFIELDS, $outstockdata);
            curl_setopt($c, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($c, CURLOPT_TIMEOUT, 30);
            $response = curl_exec($c);
            curl_close($c);

            Mage::log("end out of stock notify event", null, "myroutee.log");
        }
    }

    public function addproductwishlistrouteecron(Varien_Event_Observer $observer) {
        $event = $observer->getEvent();
        $productid = $event->getItem()->getProductId();
        $customerid = $event->getWishlist()->getCustomerId();

        Mage::log("start add product in wishlist event", null, "myroutee.log");

        $uuid = Mage::getStoreConfig('routeesection/routeegroup/routee_mmid');

        $event = "WishlistAdd";

        $reqdata = array();
        $reqdata['product_id'] = $productid;
        $reqdata['customer_id'] = $customerid;

        $eventdata = array();
        $eventdata['data'] = $reqdata;
        $eventdata['uuid'] = $uuid;
        $eventdata['event'] = $event;

        $wishlistdata = Mage::helper('core')->jsonEncode($eventdata);

        $url = "https://idata.routee.net/api/event";

        $c = curl_init();
        curl_setopt($c, CURLOPT_URL, $url);
        curl_setopt($c, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
        curl_setopt($c, CURLOPT_POST, true);
        curl_setopt($c, CURLOPT_POSTFIELDS, $wishlistdata);
        curl_setopt($c, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($c, CURLOPT_TIMEOUT, 30);
        $response = curl_exec($c);
        curl_close($c);

        Mage::log("end add product in wishlist event", null, "myroutee.log");
    }

    public function removeproductwishlistrouteecron(Varien_Event_Observer $observer) {
        $item = Mage::app()->getRequest()->getParam('item');
        if ($item) {
            $item = Mage::getModel('wishlist/item')->load($item);
            $productId = $item->getProductId();
            $wishlist = Mage::getModel('wishlist/wishlist')->load($item->getWishlistId());
            $customerid = $wishlist->getCustomerId();

            Mage::log("start remove product in wishlist event", null, "myroutee.log");
            $uuid = Mage::getStoreConfig('routeesection/routeegroup/routee_mmid');
            $event = "WishlistDelete";

            $reqdata = array();
            $reqdata['product_id'] = $productId;
            $reqdata['customer_id'] = $customerid;

            $eventdata = array();
            $eventdata['data'] = $reqdata;
            $eventdata['uuid'] = $uuid;
            $eventdata['event'] = $event;

            $wishlistdata = Mage::helper('core')->jsonEncode($eventdata);

            $url = "https://idata.routee.net/api/event";

            $c = curl_init();
            curl_setopt($c, CURLOPT_URL, $url);
            curl_setopt($c, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
            curl_setopt($c, CURLOPT_POST, true);
            curl_setopt($c, CURLOPT_POSTFIELDS, $wishlistdata);
            curl_setopt($c, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($c, CURLOPT_TIMEOUT, 30);
            $response = curl_exec($c);
            curl_close($c);

            Mage::log("end remove product in wishlist event", null, "myroutee.log");
        }
    }

    public function addproducttocartrouteecron(Varien_Event_Observer $observer) {

        $quoteitem = $observer->getEvent()->getQuoteItem();
        $quote = $quoteitem->getQuote();
        $customerid = $quote->getCustomerId();

        $prd = array();
        $proddconfg = array();

        foreach ($quote->getAllItems() as $item) {
            if ($item->getProductType() != "configurable") {
                $prodd = array();
                $prodd['product_id'] = $item->getProductId();

                $parentIds = Mage::getModel('catalog/product_type_grouped')->getParentIdsByChild($item->getProductId());
                if (!$parentIds) {
                    $parentIds = Mage::getModel('catalog/product_type_configurable')->getParentIdsByChild($item->getProductId());
                }

                if (isset($parentIds[0])) {
                    $prodd['quantity'] = (int) $proddconfg['quantity'];
                } else {
                    $prodd['quantity'] = (int) $item->getQty();
                }
                $prd[] = $prodd;
            } else {
                $proddconfg['product_id'] = $item->getProductId();
                $proddconfg['quantity'] = (int) $item->getQty();
            }
        }

        Mage::log("start add product in cart event", null, "myroutee.log");

        $uuid = Mage::getStoreConfig('routeesection/routeegroup/routee_mmid');

        $event = "CartUpdate";

        $reqdata = array();
        $reqdata['customer_id'] = $customerid;
        $reqdata['cart_products'] = $prd;

        $eventdata = array();
        $eventdata['data'] = $reqdata;
        $eventdata['uuid'] = $uuid;
        $eventdata['event'] = $event;

        $cardadddata = Mage::helper('core')->jsonEncode($eventdata);

        $url = "https://idata.routee.net/api/event";

        $c = curl_init();
        curl_setopt($c, CURLOPT_URL, $url);
        curl_setopt($c, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
        curl_setopt($c, CURLOPT_POST, true);
        curl_setopt($c, CURLOPT_POSTFIELDS, $cardadddata);
        curl_setopt($c, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($c, CURLOPT_TIMEOUT, 30);
        $response = curl_exec($c);
        curl_close($c);

        Mage::log("end add product in cart event", null, "myroutee.log");
    }

    public function updateproducttocartrouteecron(Varien_Event_Observer $observer) {
        $quoteitem = $observer->getEvent()->getQuoteItem();
        $quote = $quoteitem->getQuote();
        $customerid = $quote->getCustomerId();

        $prd = array();
        $proddconfg = array();

        foreach ($quote->getAllItems() as $item) {
            if ($item->getProductType() != "configurable") {
                $prodd = array();
                $prodd['product_id'] = $item->getProductId();

                if (!$item->getParentItemId()) {
                    $prodd['quantity'] = (int) $item->getQty();
                } else {
                    $prodd['quantity'] = (int) $proddconfg['quantity'];
                }
                $prd[] = $prodd;
            } else {
                $proddconfg['product_id'] = $item->getProductId();
                $proddconfg['quantity'] = (int) $item->getQty();
            }
        }

        Mage::log("start update product in cart event", null, "myroutee.log");

        $uuid = Mage::getStoreConfig('routeesection/routeegroup/routee_mmid');

        $event = "CartUpdate";

        $reqdata = array();
        $reqdata['customer_id'] = $customerid;
        $reqdata['cart_products'] = $prd;

        $eventdata = array();
        $eventdata['data'] = $reqdata;
        $eventdata['uuid'] = $uuid;
        $eventdata['event'] = $event;

        $cardadddata = Mage::helper('core')->jsonEncode($eventdata);

        $url = "https://idata.routee.net/api/event";

        $c = curl_init();
        curl_setopt($c, CURLOPT_URL, $url);
        curl_setopt($c, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
        curl_setopt($c, CURLOPT_POST, true);
        curl_setopt($c, CURLOPT_POSTFIELDS, $cardadddata);
        curl_setopt($c, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($c, CURLOPT_TIMEOUT, 30);
        $response = curl_exec($c);
        curl_close($c);

        Mage::log("end update product in cart event", null, "myroutee.log");
    }

    public function updateitemtocartrouteecron(Varien_Event_Observer $observer) {
        $quote = $observer->getEvent()->getCart()->getQuote();
        $customerid = $quote->getCustomerId();

        $prd = array();
        $proddconfg = array();

        foreach ($quote->getAllItems() as $item) {
            if ($item->getProductType() != "configurable") {
                $prodd = array();
                $prodd['product_id'] = $item->getProductId();

                if (!$item->getParentItemId()) {
                    $prodd['quantity'] = (int) $item->getQty();
                } else {
                    $prodd['quantity'] = (int) $proddconfg['quantity'];
                }
                $prd[] = $prodd;
            } else {
                $proddconfg['product_id'] = $item->getProductId();
                $proddconfg['quantity'] = (int) $item->getQty();
            }
        }

        Mage::log("start update item in cart event", null, "myroutee.log");

        $uuid = Mage::getStoreConfig('routeesection/routeegroup/routee_mmid');

        $event = "CartUpdate";

        $reqdata = array();
        $reqdata['customer_id'] = $customerid;
        $reqdata['cart_products'] = $prd;

        $eventdata = array();
        $eventdata['data'] = $reqdata;
        $eventdata['uuid'] = $uuid;
        $eventdata['event'] = $event;

        $cardadddata = Mage::helper('core')->jsonEncode($eventdata);

        $url = "https://idata.routee.net/api/event";

        $c = curl_init();
        curl_setopt($c, CURLOPT_URL, $url);
        curl_setopt($c, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
        curl_setopt($c, CURLOPT_POST, true);
        curl_setopt($c, CURLOPT_POSTFIELDS, $cardadddata);
        curl_setopt($c, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($c, CURLOPT_TIMEOUT, 30);
        $response = curl_exec($c);
        curl_close($c);

        Mage::log("end update item in cart event", null, "myroutee.log");
    }

    public function removeproducttocartrouteecron(Varien_Event_Observer $observer) {
        $quoteitem = $observer->getEvent()->getQuoteItem();
        $quote = $quoteitem->getQuote();
        $customerid = $quote->getCustomerId();

        $prd = array();
        $proddconfg = array();

        foreach ($quote->getAllItems() as $item) {
            if ($item->getProductType() != "configurable") {
                $prodd = array();
                $prodd['product_id'] = $item->getProductId();

                if (!$item->getParentItemId()) {
                    $prodd['quantity'] = (int) $item->getQty();
                } else {
                    $prodd['quantity'] = (int) $proddconfg['quantity'];
                }
                $prd[] = $prodd;
            } else {
                $proddconfg['product_id'] = $item->getProductId();
                $proddconfg['quantity'] = (int) $item->getQty();
            }
        }

        Mage::log("start remove product in cart event", null, "myroutee.log");

        $uuid = Mage::getStoreConfig('routeesection/routeegroup/routee_mmid');

        $event = "CartUpdate";

        $reqdata = array();
        $reqdata['customer_id'] = $customerid;
        $reqdata['cart_products'] = $prd;

        $eventdata = array();
        $eventdata['data'] = $reqdata;
        $eventdata['uuid'] = $uuid;
        $eventdata['event'] = $event;

        $cardadddata = Mage::helper('core')->jsonEncode($eventdata);

        $url = "https://idata.routee.net/api/event";

        $c = curl_init();
        curl_setopt($c, CURLOPT_URL, $url);
        curl_setopt($c, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
        curl_setopt($c, CURLOPT_POST, true);
        curl_setopt($c, CURLOPT_POSTFIELDS, $cardadddata);
        curl_setopt($c, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($c, CURLOPT_TIMEOUT, 30);
        $response = curl_exec($c);
        curl_close($c);

        Mage::log("end remove product in cart event", null, "myroutee.log");
    }

    public function removeallproducttocartrouteecron(Varien_Event_Observer $observer) {
        $quote = Mage::getSingleton('checkout/session')->getQuote();
        $customerid = $quote->getCustomerId();

        $updateAction = (string) Mage::app()->getRequest()->getParam('update_cart_action');
        if ($updateAction == 'empty_cart') {
            Mage::log("start remove all product in cart event", null, "myroutee.log");

            $uuid = Mage::getStoreConfig('routeesection/routeegroup/routee_mmid');

            $event = "CartUpdate";

            $reqdata = array();
            $reqdata['customer_id'] = $customerid;
            $reqdata['cart_products'] = array();

            $eventdata = array();
            $eventdata['data'] = $reqdata;
            $eventdata['uuid'] = $uuid;
            $eventdata['event'] = $event;

            $cardadddata = Mage::helper('core')->jsonEncode($eventdata);

            $url = "https://idata.routee.net/api/event";

            $c = curl_init();
            curl_setopt($c, CURLOPT_URL, $url);
            curl_setopt($c, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
            curl_setopt($c, CURLOPT_POST, true);
            curl_setopt($c, CURLOPT_POSTFIELDS, $cardadddata);
            curl_setopt($c, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($c, CURLOPT_TIMEOUT, 30);
            $response = curl_exec($c);
            curl_close($c);

            Mage::log("end remove all product in cart event", null, "myroutee.log");
        }
    }

    public function addnewslaterrouteecron(Varien_Event_Observer $observer) {
        $email = Mage::app()->getRequest()->getPost('email');

        $ownerId = Mage::getModel('customer/customer')
                ->setWebsiteId(Mage::app()->getStore()->getWebsiteId())
                ->loadByEmail($email)
                ->getId();

        if (!$ownerId) {
            $ownerId = 0;
        }

        Mage::log("start add newslater event", null, "myroutee.log");

        $uuid = Mage::getStoreConfig('routeesection/routeegroup/routee_mmid');

        $event = "Newsletter";

        $reqdata = array();
        $reqdata['customer_id'] = $ownerId;
        $reqdata['email'] = $email;
        $reqdata['subscription'] = true;

        $eventdata = array();
        $eventdata['data'] = $reqdata;
        $eventdata['uuid'] = $uuid;
        $eventdata['event'] = $event;

        $newsdata = Mage::helper('core')->jsonEncode($eventdata);

        $url = "https://idata.routee.net/api/event";

        $c = curl_init();
        curl_setopt($c, CURLOPT_URL, $url);
        curl_setopt($c, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
        curl_setopt($c, CURLOPT_POST, true);
        curl_setopt($c, CURLOPT_POSTFIELDS, $newsdata);
        curl_setopt($c, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($c, CURLOPT_TIMEOUT, 30);
        $response = curl_exec($c);
        curl_close($c);

        Mage::log("end add newslater event", null, "myroutee.log");
    }

    public function removenewslaterrouteecron(Varien_Event_Observer $observer) {
        $id = (int) Mage::app()->getRequest()->getParam('id');
        $code = (string) Mage::app()->getRequest()->getParam('code');

        if ($id & $code) {
            $newslater = Mage::getModel('newsletter/subscriber')->load($id);

            Mage::log("start remove newslater event", null, "myroutee.log");

            $uuid = Mage::getStoreConfig('routeesection/routeegroup/routee_mmid');

            $event = "Newsletter";

            $reqdata = array();
            $reqdata['customer_id'] = $newslater->getCustomerId();
            $reqdata['email'] = $newslater->getEmail();
            $reqdata['subscription'] = false;

            $eventdata = array();
            $eventdata['data'] = $reqdata;
            $eventdata['uuid'] = $uuid;
            $eventdata['event'] = $event;

            $cardadddata = Mage::helper('core')->jsonEncode($eventdata);

            $url = "https://idata.routee.net/api/event";

            $c = curl_init();
            curl_setopt($c, CURLOPT_URL, $url);
            curl_setopt($c, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
            curl_setopt($c, CURLOPT_POST, true);
            curl_setopt($c, CURLOPT_POSTFIELDS, $cardadddata);
            curl_setopt($c, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($c, CURLOPT_TIMEOUT, 30);
            $response = curl_exec($c);
            curl_close($c);

            Mage::log("end remove newslater event", null, "myroutee.log");
        }
    }

    public function searchrouteecron(Varien_Event_Observer $observer) {
        $searqq = Mage::app()->getRequest()->getParam('q');
        $customerSession = Mage::getSingleton('customer/session');
        $ownerId = $customerSession->getId();

        if (!$ownerId) {
            $ownerId = 0;
        }
        if ($searqq) {
            Mage::log("start catalog search event", null, "myroutee.log");

            $uuid = Mage::getStoreConfig('routeesection/routeegroup/routee_mmid');

            $event = "Search";

            $reqdata = array();
            $reqdata['customer_id'] = $ownerId;
            $reqdata['search_string'] = $searqq;

            $eventdata = array();
            $eventdata['data'] = $reqdata;
            $eventdata['uuid'] = $uuid;
            $eventdata['event'] = $event;

            $searchdata = Mage::helper('core')->jsonEncode($eventdata);

            $url = "https://idata.routee.net/api/event";

            $c = curl_init();
            curl_setopt($c, CURLOPT_URL, $url);
            curl_setopt($c, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
            curl_setopt($c, CURLOPT_POST, true);
            curl_setopt($c, CURLOPT_POSTFIELDS, $searchdata);
            curl_setopt($c, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($c, CURLOPT_TIMEOUT, 30);
            $response = curl_exec($c);
            curl_close($c);

            Mage::log("end catalog search event", null, "myroutee.log");
        }
    }

    public function neworderrouteecron(Varien_Event_Observer $observer) {

        $orderss = $observer->getEvent()->getOrder();
        $order = Mage::getModel('sales/order')->loadByIncrementId($orderss->getIncrementId());

        $allitem = array();
        $allitemconfg = array();
        foreach ($order->getAllItems() as $item) {
            if ($item->getProductType() != "configurable") {
                $prodd = array();
                $prodd['product_id'] = $item->getProductId();

                if (!$item->getParentItemId()) {
                    $prodd['quantity'] = (int) $item->getQtyOrdered();
                } else {
                    $prodd['quantity'] = (int) $allitemconfg['quantity'];
                }
                $allitem[] = $prodd;
            } else {
                $allitemconfg['product_id'] = $item->getProductId();
                $allitemconfg['quantity'] = (int) $item->getQtyOrdered();
            }
        }

        $orderdet = array();
        $orderdet['order_id'] = $order->getId();
        $orderdet['order_status'] = $orderss->getStatus();
        $orderdet['shipping_method'] = $order->getShippingMethod();
        $orderdet['payment_method'] = $order->getPayment()->getMethodInstance()->getCode();
        $orderdet['total_price'] = $order->getGrandTotal();

        Mage::log("start new order event", null, "myroutee.log");

        $uuid = Mage::getStoreConfig('routeesection/routeegroup/routee_mmid');
        $event = "OrderAdd";

        $reqdata = array();
        $reqdata['customer_id'] = $order->getCustomerId();
        $reqdata['order_details'] = $orderdet;
        $reqdata['order_products'] = $allitem;

        $eventdata = array();
        $eventdata['data'] = $reqdata;
        $eventdata['uuid'] = $uuid;
        $eventdata['event'] = $event;

        Mage::log(print_r($eventdata, true), null, "myroutee.log");

        $orderdata = Mage::helper('core')->jsonEncode($eventdata);

        $url = "https://idata.routee.net/api/event";

        $c = curl_init();
        curl_setopt($c, CURLOPT_URL, $url);
        curl_setopt($c, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
        curl_setopt($c, CURLOPT_POST, true);
        curl_setopt($c, CURLOPT_POSTFIELDS, $orderdata);
        curl_setopt($c, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($c, CURLOPT_TIMEOUT, 30);
        $response = curl_exec($c);
        curl_close($c);

        Mage::log(print_r($response, true), null, "myroutee.log");

        Mage::log("end new order event", null, "myroutee.log");

        if ($orderss->getState() != $orderss->getOrigData('state')) {

            Mage::log("start order status change event", null, "myroutee.log");

            $uuid = Mage::getStoreConfig('routeesection/routeegroup/routee_mmid');
            $event = "OrderStatusUpdate";

            $reqdata = array();
            $reqdata['customer_id'] = $order->getCustomerId();
            $reqdata['order_id'] = $order->getId();
            $reqdata['order_status'] = $orderss->getStatus();

            $eventdata = array();
            $eventdata['data'] = $reqdata;
            $eventdata['uuid'] = $uuid;
            $eventdata['event'] = $event;

            $orderdata = Mage::helper('core')->jsonEncode($eventdata);

            $url = "https://idata.routee.net/api/event";

            $c = curl_init();
            curl_setopt($c, CURLOPT_URL, $url);
            curl_setopt($c, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
            curl_setopt($c, CURLOPT_POST, true);
            curl_setopt($c, CURLOPT_POSTFIELDS, $orderdata);
            curl_setopt($c, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($c, CURLOPT_TIMEOUT, 30);
            $response = curl_exec($c);
            curl_close($c);

            Mage::log("end order status change event", null, "myroutee.log");
        }
    }
    
    public function orderupdaterouteecron(Varien_Event_Observer $observer) {

        $orderss = $observer->getEvent()->getOrder();
        $order = Mage::getModel('sales/order')->loadByIncrementId($orderss->getIncrementId());

        if ($orderss->getState() != $orderss->getOrigData('state')) {

            Mage::log("start order status change event", null, "myroutee.log");

            $uuid = Mage::getStoreConfig('routeesection/routeegroup/routee_mmid');
            $event = "OrderStatusUpdate";

            $reqdata = array();
            $reqdata['customer_id'] = $order->getCustomerId();
            $reqdata['order_id'] = $order->getId();
            $reqdata['order_status'] = $orderss->getStatus();

            $eventdata = array();
            $eventdata['data'] = $reqdata;
            $eventdata['uuid'] = $uuid;
            $eventdata['event'] = $event;

            $orderdata = Mage::helper('core')->jsonEncode($eventdata);

            $url = "https://idata.routee.net/api/event";

            $c = curl_init();
            curl_setopt($c, CURLOPT_URL, $url);
            curl_setopt($c, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
            curl_setopt($c, CURLOPT_POST, true);
            curl_setopt($c, CURLOPT_POSTFIELDS, $orderdata);
            curl_setopt($c, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($c, CURLOPT_TIMEOUT, 30);
            $response = curl_exec($c);
            curl_close($c);

            Mage::log("end order status change event", null, "myroutee.log");
        }
    }

}
