<?php

class Ambient_Routee_Block_Adminhtml_System_Config_Form_Buttonproduct extends Mage_Adminhtml_Block_System_Config_Form_Field {
    /*
     * Set template
     */

    protected function _construct() {
        parent::_construct();
        $this->setTemplate('routee/system/config/button_product.phtml');
    }

    /**
     * Return element html
     *
     * @param  Varien_Data_Form_Element_Abstract $element
     * @return string
     */
    protected function _getElementHtml(Varien_Data_Form_Element_Abstract $element) {
        return $this->_toHtml();
    }

    /**
     * Return ajax url for button
     *
     * @return string
     */
    public function getAjaxCheckUrl() {
        return Mage::helper('adminhtml')->getUrl('adminhtml/adminhtml_routee/bulkimport');
    }

    /**
     * Generate button html
     *
     * @return string
     */
    public function getButtonHtml() {
        if (Mage::getStoreConfig('routeesection/routeegroup/routee_bulkimport') == 1) {
            $disss = true;
        } else {
            $disss = false;
        }
        $button = $this->getLayout()->createBlock('adminhtml/widget_button')
                ->setData(array(
            'id' => 'routee_button_import',
            'label' => $this->helper('adminhtml')->__('Integrate'),
            'onclick' => 'javascript:bulkproductimport()',
            'disabled' => $disss
        ));

        return $button->toHtml();
    }

}
